// Quellen: 
// https://sqlsunday.com/2014/08/17/30-360-day-count-convention/
// https://strata.opengamma.io/day_counts/
// https://en.wikipedia.org/wiki/Day_count_convention
// https://www.isda.org/a/AIJEE/1998-ISDA-memo-%E2%80%9CEMU-and-Market-Conventions-Recent-Developments%E2%80%9D.pdf
//
// Die Funktion BRTEILJAHRE_30E_360 wandelt die Anzahl der ganzen Tage zwischen Ausgangsdatum und Enddatum in Bruchteile von Jahren um
// Sie entspricht der Funktion BRTEILJAHRE(Ausgangsdatum;Enddatum;Basis) in Microsoft Excel mit der Basis 4 => Europäisch 30/360.
// Erstellt am 07.11.2021 von Frank Arendt-Theilen, Hameln
//

(Ausgangsdatum as date, Enddatum as date) as number =>
let
    //Ist der Tag des Ausgangsdatums der 31., dann den Tag des Ausgangsdatums auf den 30. abändern
    Ausgangsdatum_Tag = if Date.Day(Ausgangsdatum) = 31 then 30 else Date.Day(Ausgangsdatum),
    Ausgangsdatum_Monat = Date.Month(Ausgangsdatum),
    Ausgangsdatum_Jahr = Date.Year(Ausgangsdatum),

    //Ist der Tag des Enddatums der 31., dann den Tag des Enddatums auf den 30. abändern
    Enddatum_Tag = if Date.Day(Enddatum) = 31 then 30 else Date.Day(Enddatum),
    Enddatum_Monat = Date.Month(Enddatum),
    Enddatum_Jahr = Date.Year(Enddatum),

    BRTEILJAHRE_30E_360 = 
    if Enddatum >= Ausgangsdatum then
        ( 360 * ( Enddatum_Jahr - Ausgangsdatum_Jahr) + 30 * ( Enddatum_Monat - Ausgangsdatum_Monat ) + ( Enddatum_Tag - Ausgangsdatum_Tag )) / 360
    else
        ( 360 * ( Ausgangsdatum_Jahr - Enddatum_Jahr) + 30 * ( Ausgangsdatum_Monat - Enddatum_Monat ) + ( Ausgangsdatum_Tag - Enddatum_Tag )) / 360

in
    BRTEILJAHRE_30E_360