// fxZeilenMitFehlernErmitteln

(Tabelle as table) =>

let
    Quelle = Tabelle,
    SpaltennamenListen = Table.ColumnNames(Quelle),
    AnzahlZeilen = Table.RowCount(Quelle),
    InTabellekonvertieren = Table.FromList(SpaltennamenListen, Splitter.SplitByNothing(), null, null, ExtraValues.Error),
    SpalteHinzufügen = Table.AddColumn(InTabellekonvertieren, "Benutzerdefiniert", each Table.Column(Quelle, [Column1])),
    ListeErweiteren = Table.ExpandListColumn(SpalteHinzufügen, "Benutzerdefiniert"),
    IndexHinzufügen = Table.AddIndexColumn(ListeErweiteren, "Index", 0, 1),
    ModuloBilden = Table.TransformColumns(IndexHinzufügen, {{"Index", each Number.Mod(_, AnzahlZeilen) + 1, type number}}),
    SpaltenUmbenennen = Table.RenameColumns(ModuloBilden,{{"Index", "Zeile"}, {"Column1", "Spalte"}}),
    ZeilenMitFehler = Table.SelectRowsWithErrors(SpaltenUmbenennen, {"Benutzerdefiniert"}),
	Try_SpalteHinzufügen = Table.AddColumn(ZeilenMitFehler, "Error", each try([Benutzerdefiniert])),
    ErweiterterterFehlerRecord = Table.ExpandRecordColumn(Try_SpalteHinzufügen, "Error", {"Error"}, {"FehlerRecord"}),
    ErweiterteFehlermeldungen = Table.ExpandRecordColumn(ErweiterterterFehlerRecord, "FehlerRecord", {"Message", "Detail"}, {"Message", "Detail"}),
    EntfernteSpalten = Table.RemoveColumns(ErweiterteFehlermeldungen,{"Benutzerdefiniert"}),
    NeuAngeordneteSpalten = Table.ReorderColumns(EntfernteSpalten,{"Spalte", "Zeile", "Detail", "Message"}),
    UmbenannteSpalten = Table.RenameColumns(NeuAngeordneteSpalten,{{"Detail", "aktueller Wert"}}),
    GeänderterTyp = Table.TransformColumnTypes(UmbenannteSpalten,{{"Spalte", type text}, {"Message", type text}})
in
    GeänderterTyp